/**
* \file: AditMediaPlaybackStatus.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_ADITMEDIAPLAYBACKSTATUS_H
#define AAUTO_ADITMEDIAPLAYBACKSTATUS_H

#include <aauto/MediaPlaybackStatusEndpoint.h>
#include <aauto/MessageRouter.h>

namespace adit { namespace aauto {

/**
 * @brief callbacks to receive media playback status notifications from MD.
 * All callbacks have empty default implementations.
 * If necessary, need to be implemented . */
class IAditMediaPlaybackStatusCallbacks
{
public:
    virtual ~IAditMediaPlaybackStatusCallbacks() {}

    /**
     * @brief Called when media playback status message comes through.
     * @param inStatus incoming media playback status:
     *      state: STOPPED = 1, PLAYING = 2, PAUSED = 3
     *      media_source: Source of current media.
     *      playback_seconds: Current playback of song in seconds.
     *      shuffle: True if shuffle is on.
     *      repeat: True if repeat is one.
     *      repeat_one: True if repeating one song.
     * @return neither stated nor handled by Google, preserve the GalReceiver API here
     */
    virtual int mediaPlaybackStatusCallback(struct MediaPlaybackStatusStruct inStatus)
    {
        (void) inStatus;
        return 0;
    }

    /**
     * @brief Called when media playback metadata message comes through.
     * @param inMetadata incoming media playback metadata:
     *      song: Name of current song.
     *      album: Album of current song.
     *      artist: Artist of current song.
     *      album_art: Album art in PNG format.
     *      playlist: Name of the current playlist.
     *      duration_seconds: Length of current song in seconds.
     *      rating: Rating of current song from 0-5.
     * @return neither stated nor handled by Google, preserve the GalReceiver API here
     */
    virtual int mediaPlaybackMetadataCallback(struct MediaPlaybackMetadataStruct inMetadata)
    {
        (void) inMetadata;
        return 0;
    }
};

/**
 * @brief AditMediaPlaybackStatus provides a generic base class for MediaPlaybackStatus implementations. */
class AditMediaPlaybackStatus : public MediaPlaybackStatusEndpoint
{
public:
    AditMediaPlaybackStatus(uint8_t inSessionId, MessageRouter* inMessageRouter) :
        MediaPlaybackStatusEndpoint(inSessionId, inMessageRouter) {}

    /**
     * @brief Set configuration for platform and AAuto-related items.
     *         All configurations must be called before init().
     * @param  inKey        The key string for configuration
     * @param  inValue      The actual value for configuration */
    virtual void setConfigItem(string inKey, string inValue) = 0;

    /**
     * @brief Register callbacks to receive media playback status notifications.
     * @param   inCallbacks object implementing the callback interface */
    virtual void registerCallbacks(IAditMediaPlaybackStatusCallbacks* inCallbacks) = 0;

    /**
     * @brief Initialize the endpoint.
     *      All configuration items must be set before calling this function.
     * @return true if initialization succeeds.
     *      false if fails. */
    virtual bool init() = 0;

    /**
     * @brief  Shut down the endpoint and release allocated resources */
    virtual void shutdown() = 0;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_ADITMEDIAPLAYBACKSTATUS_H */

